<!DOCTYPE html>
<html lang="zh-Hant-TW">

<?php include('./head.php'); ?>

<body class="news" data-no="0">

  <?php include('./header.php'); ?>

  <main>
    <div class="container-xl position-relative">

      <button id="showNewsInsertForm" class="btn btn-danger position-absolute start-0 top-0">顯示新增表單</button>

      <h1>新訊管理中心</h1>

      <form id="newsInsertForm" method="post" action="./admin_news_process.php" class="shadow-lg rounded border border-secondary p-3 mb-4 d-none" enctype="multipart/form-data">
        <div class="row">

          <!-- 左側顯示上傳圖片 -->
          <div class="col-12 col-md-4 text-center">

            <!-- 以label標籤包含input標籤, 讓input標籤隱藏, 設計label標籤呈現視覺看到的樣子 -->
            <!-- 當按到label標籤時, 即代表了按到了input標籤(選擇檔案準備上傳檔案) -->
            <label class="btn btn-secondary cursor-p">
              <input type="file" name="news_img" id="news_img" accept=".jpg,.jpeg,.png,.gif" class="d-none">

              <i class="bi bi-image"></i> 上傳圖片
            </label>

            <br><small>請選擇寬度大於 1000px，<br>
              容量小於 1M 的 jpg / png / gif 圖片</small>

            <!-- #imgErrMsg 這個區域負責顯示選擇圖的錯誤訊息 -->
            <div id="imgErrMsg" style="color:red;font-weight:bold"></div>

            <!--#imgArea 這個區域負責顯示所選擇的圖檔, 也就是影像的預覽區域 -->
            <div id="imgArea" class="p-3">
              <img class="imgArea d-block mw-100">
            </div>

          </div>

          <!-- 右側顯示其他欄位 -->
          <div class="col-12 col-md-8 col-right">

            <div class="d-flex align-items-center">
              <div class="col-icon"><i class="bi bi-folder-fill"></i></div>
              <div class="flex-fill select_news_class">
                <!-- 這裡是下拉式選單選擇新訊分類 -->
                <select name="news_class_id" class="form-select" required>
                  <option value="" disabled selected>選擇新訊的分類...</option>

                  <option value="">新訊的分類</option>
                  <option value="">新訊的分類</option>
                  <option value="">新訊的分類</option>
                  <option value="">新訊的分類</option>

                </select>
              </div>
            </div>

            <div class="d-flex align-items-center">
              <div class="col-icon"><i class="bi bi-flag-fill"></i></div>
              <div class="flex-fill">
                <!-- 這裡是新訊標題欄位 -->
                <input type="text" name="news_title" maxlength="30" class="form-control" placeholder="輸入新訊的標題" required>
              </div>
            </div>

            <div class="d-flex align-items-top">
              <div class="col-icon"><i class="bi bi-chat-left-text-fill"></i></div>
              <div class="flex-fill">
                <!-- 這裡是新訊內容欄位 -->
                <textarea name="news_content" class="form-control" rows="5" placeholder="輸入新訊的內容" required></textarea>
              </div>
            </div>

            <div class="d-flex align-items-center">
              <div class="col-icon"><i class="bi bi-geo-alt-fill"></i></div>
              <div class="flex-fill d-flex justify-content-between">
                <!-- 這裡是設計是否為焦點新訊的欄位 -->
                <div>
                  <label class="cursor-p me-4">
                    <input type="radio" name="news_focus" class="form-check-input" value="1">
                    是焦點新訊</label>

                  <label class="cursor-p">
                    <input type="radio" name="news_focus" class="form-check-input" value="0" checked>
                    非焦點新訊</label>
                </div>

                <div class="w3-right">
                  <label class="cursor-p">
                    <input type="checkbox" name="news_show" class="form-check-input" value="1" checked> 顯示</label>
                </div>
              </div>
            </div>

          </div>

          <!-- 表單下方按鈕區域 -->
          <div class="col-12 form-btn-area mt-2">
            <input type="submit" class="btn btn-secondary d-block w-100" value="確定新增新訊">
          </div>

        </div>
        <input type="hidden" name="MM_process" value="insert">
      </form>


      <div class="d-flex align-items-center justify-content-between">
        <p>-----全部 的新訊 有 99 篇 -----</p>
        <!-- 關鍵字搜尋表單準備區 -->
        <form method="get" action="" class="w3-right d-flex pb-2">
          <input type="text" name="search_keyword" class="form-control" style="width:22em" placeholder="新訊關鍵字, 不輸入按「搜尋」則顯示全部...">
          <input type="submit" class="btn btn-outline-dark" value="搜尋">
        </form>
      </div>


      <div class="table-responsive">
        <table class="table">
          <tbody>
            <tr>
              <th width="150" class="text-center">功能</th>
              <th width="80" class="text-center">分類</th>
              <th>[ID]標題</th>
              <th width="50" class="text-center">焦點</th>
              <th width="50" class="text-center">顯示</th>
              <th>建檔時間</th>
              <th>修改時間</th>
              <th width="90" class="text-center">縮圖</th>
              <th>建檔人員</th>
            </tr>


            <tr>
              <!-- 第1格：功能 -->
              <td class="text-center">

                <a href="./admin_news_modify.php" class="btn btn-outline-warning process-btn">修改</a>

                <a href="./admin_news_delete.php" class="btn btn-outline-secondary process-btn">刪除</a>
              </td>

              <!-- 第2格：分類 -->
              <td class="text-center">分類 </td>

              <!-- 第3格：[ID]標題 -->
              <td>
                <div class="d-flex align-items-center">
                  [ID-no]
                  <a href="./admin_news_detail.php" class="btn btn-outline-info text-black d-inline-block wordhidden text-start process-btn" style="width: 360px;">
                    標題
                  </a>
                </div>
              </td>

              <!-- 第4格：是否為焦點 -->
              <td class="text-center"> V </td>

              <!-- 第5格：是否顯示 -->
              <td class="text-center"> V </td>

              <!-- 第6格：建檔時間 -->
              <td>2021-02-25 00:47:04</td>

              <!-- 第7格：修改時間 -->
              <td>2021-02-25 00:47:04</td>

              <!-- 第8格：顯示縮圖 -->
              <td class="text-center">
                <img src="../img_layout/pre_img_news.png" height="50" alt="">
              </td>

              <!-- 第9格：建檔人員 -->
              <td>初始測試</td>
            </tr>

            <tr>
              <!-- 第1格：功能 -->
              <td class="text-center">

                <a href="./admin_news_modify.php" class="btn btn-outline-warning process-btn">修改</a>

                <a href="./admin_news_delete.php" class="btn btn-outline-secondary process-btn">刪除</a>
              </td>

              <!-- 第2格：分類 -->
              <td class="text-center">分類 </td>

              <!-- 第3格：[ID]標題 -->
              <td>
                <div class="d-flex align-items-center">
                  [ID-no]
                  <a href="./admin_news_detail.php" class="btn btn-outline-info text-black d-inline-block wordhidden text-start process-btn" style="width: 360px;">
                    標題
                  </a>
                </div>
              </td>

              <!-- 第4格：是否為焦點 -->
              <td class="text-center"> V </td>

              <!-- 第5格：是否顯示 -->
              <td class="text-center"> V </td>

              <!-- 第6格：建檔時間 -->
              <td>2021-02-25 00:47:04</td>

              <!-- 第7格：修改時間 -->
              <td>2021-02-25 00:47:04</td>

              <!-- 第8格：顯示縮圖 -->
              <td class="text-center">
                <img src="../img_layout/pre_img_news.png" height="50" alt="">
              </td>

              <!-- 第9格：建檔人員 -->
              <td>初始測試</td>
            </tr>

            <tr>
              <!-- 第1格：功能 -->
              <td class="text-center">

                <a href="./admin_news_modify.php" class="btn btn-outline-warning process-btn">修改</a>

                <a href="./admin_news_delete.php" class="btn btn-outline-secondary process-btn">刪除</a>
              </td>

              <!-- 第2格：分類 -->
              <td class="text-center">分類 </td>

              <!-- 第3格：[ID]標題 -->
              <td>
                <div class="d-flex align-items-center">
                  [ID-no]
                  <a href="./admin_news_detail.php" class="btn btn-outline-info text-black d-inline-block wordhidden text-start process-btn" style="width: 360px;">
                    標題
                  </a>
                </div>
              </td>

              <!-- 第4格：是否為焦點 -->
              <td class="text-center"> V </td>

              <!-- 第5格：是否顯示 -->
              <td class="text-center"> V </td>

              <!-- 第6格：建檔時間 -->
              <td>2021-02-25 00:47:04</td>

              <!-- 第7格：修改時間 -->
              <td>2021-02-25 00:47:04</td>

              <!-- 第8格：顯示縮圖 -->
              <td class="text-center">
                <img src="../img_layout/pre_img_news.png" height="50" alt="">
              </td>

              <!-- 第9格：建檔人員 -->
              <td>初始測試</td>
            </tr>

            <tr>
              <!-- 第1格：功能 -->
              <td class="text-center">

                <a href="./admin_news_modify.php" class="btn btn-outline-warning process-btn">修改</a>

                <a href="./admin_news_delete.php" class="btn btn-outline-secondary process-btn">刪除</a>
              </td>

              <!-- 第2格：分類 -->
              <td class="text-center">分類 </td>

              <!-- 第3格：[ID]標題 -->
              <td>
                <div class="d-flex align-items-center">
                  [ID-no]
                  <a href="./admin_news_detail.php" class="btn btn-outline-info text-black d-inline-block wordhidden text-start process-btn" style="width: 360px;">
                    標題
                  </a>
                </div>
              </td>

              <!-- 第4格：是否為焦點 -->
              <td class="text-center"> V </td>

              <!-- 第5格：是否顯示 -->
              <td class="text-center"> V </td>

              <!-- 第6格：建檔時間 -->
              <td>2021-02-25 00:47:04</td>

              <!-- 第7格：修改時間 -->
              <td>2021-02-25 00:47:04</td>

              <!-- 第8格：顯示縮圖 -->
              <td class="text-center">
                <img src="../img_layout/pre_img_news.png" height="50" alt="">
              </td>

              <!-- 第9格：建檔人員 -->
              <td>初始測試</td>
            </tr>

          </tbody>
        </table>
      </div>

      <!-- 頁碼導覽列 -->
      <nav aria-label="Page navigation" class="position-relative">
        <ul class="pagination justify-content-center">
          <li class="page-item">
            <a class="page-link" href="#" aria-label="Previous">
              <span aria-hidden="true">&laquo;</span>
            </a>
          </li>
          <li class="page-item"><a class="page-link" href="#">1</a></li>
          <li class="page-item"><a class="page-link" href="#">2</a></li>
          <li class="page-item"><a class="page-link" href="#">3</a></li>
          <li class="page-item">
            <a class="page-link" href="#" aria-label="Next">
              <span aria-hidden="true">&raquo;</span>
            </a>
          </li>
        </ul>

        <!-- 下拉式選單 -->
        <div class="position-absolute top-0 end-0" style="width: 100px;">
          <select class="form-select selectPage" aria-label="Default select example">

            <option value="">1</option>
            <option value="">2</option>
            <option value="">3</option>
            <option value="">4</option>

          </select>
        </div>
      </nav>

      <!-- Button trigger modal -->
      <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#process-modal">
        Show Modal
      </button>

      <!-- Modal -->
      <div class="modal fade" id="process-modal" tabindex="-1" aria-labelledby="process-modal-label" aria-hidden="true">
        <div class="modal-dialog modal-xl">
          <div class="modal-content">
            <div class="modal-header border-0">
              <h5 class="modal-title" id="process-modal-label"></h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body content">
              ...
            </div>
          </div>
        </div>
      </div>

    </div>
  </main>




</body>

</html>