
<div class="container-xl position-relative">

  <h1>修改新訊資料</h1>

  <form id="newsUpdateForm" method="post" action="./admin_news_process.php" 
        class="shadow-lg rounded border border-secondary p-3 mb-4"
        enctype="multipart/form-data">
    <div class="row">

      <!-- 左側顯示上傳圖片 -->
      <div class="col-12 col-md-4 text-center">

        <!-- 以label標籤包含input標籤, 讓input標籤隱藏, 設計label標籤呈現視覺看到的樣子 -->
        <!-- 當按到label標籤時, 即代表了按到了input標籤(選擇檔案準備上傳檔案) -->
        <label class="btn btn-secondary cursor-p">
          <input type="file" name="news_img" id="news_img_m" class="d-none"
            accept=".jpg,.jpeg,.png,.gif" class="d-none">

          <i class="bi bi-image"></i> 上傳圖片 
        </label>

        <br><small>請選擇寬度大於 1000px，<br>
              容量小於 1M 的 jpg / png / gif 圖片</small>

        <!-- #imgErrMsg 這個區域負責顯示選擇圖的錯誤訊息 -->
        <div id="imgErrMsg_m" style="color:red;font-weight:bold"></div>

        <!--#imgArea 這個區域負責顯示所選擇的圖檔, 也就是影像的預覽區域 -->
        <div id="imgArea_m" class="p-3">
          <img class="imgArea_m d-block mw-100" src="../img_layout/pre_img_news.png">
        </div>

      </div>

      <!-- 右側顯示其他欄位 -->
      <div class="col-12 col-md-8 col-right">

        <div class="d-flex align-items-center">
          <div class="col-icon"><i class="bi bi-folder-fill"></i></div>
          <div class="flex-fill select_news_class">
            <!-- 這裡是下拉式選單選擇新訊分類 -->
            <select name="news_class_id" class="form-select" required>
                  <option value="" disabled selected>選擇新訊的分類...</option>

                    <option value="">分類項目</option>
                    <option value="">分類項目</option>
                    <option value="">分類項目</option>

                </select>
          </div>
        </div>

        <div class="d-flex align-items-center">
          <div class="col-icon"><i class="bi bi-flag-fill"></i></div>
          <div class="flex-fill">
            <!-- 這裡是新訊標題欄位 -->
            <input type="text" name="news_title" maxlength="30" class="form-control" 
              placeholder="輸入新訊的標題" required value="新訊的標題">
          </div>
        </div>

        <div class="d-flex align-items-top">
          <div class="col-icon"><i class="bi bi-chat-left-text-fill"></i></div>
          <div class="flex-fill">
            <!-- 這裡是新訊內容欄位 -->
            <textarea name="news_content" class="form-control" rows="10" placeholder="輸入新訊的內容" required>新訊內容</textarea>
          </div>
        </div>

        <div class="d-flex align-items-center">
          <div class="col-icon"><i class="bi bi-geo-alt-fill"></i></div>
          <div class="flex-fill d-flex justify-content-between">
            <!-- 這裡是設計是否為焦點新訊的欄位 -->
            <div>
              <label class="cursor-p me-4">
                <input type="radio" name="news_focus" class="form-check-input" value="1"> 是焦點新訊</label>

              <label class="cursor-p">
                <input type="radio" name="news_focus" class="form-check-input" value="0"> 非焦點新訊</label>
            </div>

            <div class="w3-right">
              <label class="cursor-p pe-3">
                <input type="checkbox" name="news_show" class="form-check-input" value="1"> 顯示</label>
            </div>
          </div>
        </div>

      </div>

      <!-- 表單下方按鈕區域 -->
      <div class="col-12 form-btn-area mt-3 d-flex">
        <input type="submit" class="btn btn-secondary d-block w-100" value="確定更新新訊">
      </div>

    </div>

    <input type="hidden" name="news_id" value="">
    <input type="hidden" name="MM_process" value="update">
  </form>

</div>

